$(function() {
    function updateListWidth() {
      var itemWidth = $('.list-item').outerWidth();
      var itemCount = $('.list-item').length;
      var itemsWidth = itemWidth * itemCount;
      $('.list-item-wrapper').outerWidth(itemsWidth);
    }
    $('#bh-sl-map-container').storeLocator({
        distanceAlert: -1,
        autoGeocode: true,
        'autoComplete': true,
        dataType: 'json',
        dataLocation: stylesheet_directory_uri + '/data/locations.json',
        dragSearch: true,
        //debug: true,
        slideMap: false,
        defaultLoc: true,
        defaultLat: '34.0522',
        defaultLng : '-118.2437',
        openNearest: true,
        infowindowTemplatePath: stylesheet_directory_uri + '/templates/infowindow-description.html',
        listTemplatePath: stylesheet_directory_uri + '/templates/location-list-description.html',
        maxDistance: true,
        'storeLimit': 50,
        nameSearch: true,
        nameAttribute: 'companyName',
        geocodeID: 'locate-me',
        'mileLang': 'mi',
        'milesLang': 'mi',
        'listColor1': '#ffffff',
        'listColor2': '#ffffff',   
        'markerImg': stylesheet_directory_uri + '/static/img/map-pin.png',
        'markerDim': { height: 45, width: 45 },
        'mapSettings': {
            mapTypeId: google.maps.MapTypeId.ROADMAP,
            zoom     : 10
        },
        'callbackSuccess': function() {
          if($(window).width() <= 768){
            setTimeout(updateListWidth, 500);
          }
        }
  });
});   
  var Webflow = Webflow || [];
  Webflow.push(function() {
    $('label.radio-wrap').on('click touch', function () {
      var place = $(this).find('input').val();
      $('input#bh-sl-search').val('');
      $('input#bh-sl-address').val(place);
      $('select#bh-sl-maxdistance').val('300');
      $('input#bh-sl-submit').trigger('click');
    }); 
    $('label.radio-wrap.india, label.radio-wrap.canada').on('click touch', function () {
      var place = $(this).find('input').val();
      $('input#bh-sl-search').val('');
      $('input#bh-sl-address').val(place);
      $('select#bh-sl-maxdistance').val('1000');
      $('input#bh-sl-submit').trigger('click');
    }); 
    $('input#bh-sl-search').on('click touch', function () {
      $('select#bh-sl-maxdistance').val('25000');
    });
    $( function() {
      $.ajax({    
          url: stylesheet_directory_uri + '/data/locations.json',
          dataType: 'json',
          success: function(data, status) {
              $.each(data, function(i, item) {
                availableCompanies.push( item.companyName );
              });
              var uniqueCompanies = unique(availableCompanies);
              $( "#bh-sl-search" ).autocomplete({
                  source: uniqueCompanies,
                  select: function(event, ui) { 
                      $(this).val(ui.item.label);
                      $('input#bh-sl-submit').trigger('click');
                    }
              });
          }
      });      

      function unique(list) {
        var result = [];
        $.each(list, function(i, e) {
          if ($.inArray(e, result) == -1) result.push(e);
        });
        return result;
      }

      var availableCompanies = [];
    } );
  });